function [sensdat floc] = loadsensdata(filename)
% 1st line is sensor location
% 2nd line is column descriptors
% Data starts on third line (date/time, temp, humidity, pressure and lightlevel)
% Returns data in 'sensdat' and sensor location in 'floc'

dtformat = 'yyyy-mm-dd HH:MM:SS'; % date/time format

% find file creation/start log time (line 2) and the column names
fid = fopen(filename);
floc = fgets(fid); % first line is sensor location
fnames = fgets(fid); % 2nd line contains column descriptors

% scans in entire data set regardless of variable type
while ~feof(fid)
	[sdat] = textscan(fid, '%s %s %f %f %f %f');
end

fclose(fid);

% extract the date/time data out and convert to a serial date number
tmdat = zeros(length(sdat{1}), 1);
for i = 1 : length(sdat{1})
	dtstr = sprintf('%s %s', sdat{1}{i},  sdat{2}{i});
	tmdat(i) = datenum( dtstr, dtformat);
end

temp = sdat{3};
hum = sdat{4};
press = sdat{5};
light = sdat{6};

sensdat = [tmdat temp hum press light];

end
